//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

using System.IO;
using System.Security;
using System.Security.Cryptography;

namespace CLRUnleashed
{
	/// <summary>
	/// Podsumowanie dla HashForm.
	/// </summary>
	public class HashForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.TextBox adata;
		private System.Windows.Forms.TextBox bdata;
		private System.Windows.Forms.TextBox ahash;
		private System.Windows.Forms.TextBox bhash;
		private System.Windows.Forms.Button computeHashButton;
		private System.Windows.Forms.Label comparison;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public HashForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();

			comparison.Text = "";

		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.adata = new System.Windows.Forms.TextBox();
			this.bdata = new System.Windows.Forms.TextBox();
			this.ahash = new System.Windows.Forms.TextBox();
			this.bhash = new System.Windows.Forms.TextBox();
			this.computeHashButton = new System.Windows.Forms.Button();
			this.comparison = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Trebuchet MS", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(8, 16);
			this.label1.Name = "label1";
			this.label1.TabIndex = 0;
			this.label1.Text = "Dane A";
			// 
			// label2
			// 
			this.label2.Font = new System.Drawing.Font("Trebuchet MS", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label2.Location = new System.Drawing.Point(432, 16);
			this.label2.Name = "label2";
			this.label2.TabIndex = 1;
			this.label2.Text = "Dane B";
			// 
			// label3
			// 
			this.label3.Font = new System.Drawing.Font("Trebuchet MS", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label3.Location = new System.Drawing.Point(8, 136);
			this.label3.Name = "label3";
			this.label3.TabIndex = 2;
			this.label3.Text = "Skrt A";
			// 
			// label4
			// 
			this.label4.Font = new System.Drawing.Font("Trebuchet MS", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label4.Location = new System.Drawing.Point(432, 136);
			this.label4.Name = "label4";
			this.label4.TabIndex = 3;
			this.label4.Text = "Skrt B";
			// 
			// adata
			// 
			this.adata.Font = new System.Drawing.Font("Trebuchet MS", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.adata.Location = new System.Drawing.Point(8, 48);
			this.adata.Multiline = true;
			this.adata.Name = "adata";
			this.adata.Size = new System.Drawing.Size(312, 72);
			this.adata.TabIndex = 4;
			this.adata.Text = "";
			// 
			// bdata
			// 
			this.bdata.Font = new System.Drawing.Font("Trebuchet MS", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.bdata.Location = new System.Drawing.Point(424, 48);
			this.bdata.Multiline = true;
			this.bdata.Name = "bdata";
			this.bdata.Size = new System.Drawing.Size(312, 72);
			this.bdata.TabIndex = 5;
			this.bdata.Text = "";
			// 
			// ahash
			// 
			this.ahash.Font = new System.Drawing.Font("Trebuchet MS", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.ahash.Location = new System.Drawing.Point(8, 168);
			this.ahash.Multiline = true;
			this.ahash.Name = "ahash";
			this.ahash.ReadOnly = true;
			this.ahash.Size = new System.Drawing.Size(312, 72);
			this.ahash.TabIndex = 6;
			this.ahash.Text = "";
			// 
			// bhash
			// 
			this.bhash.Font = new System.Drawing.Font("Trebuchet MS", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.bhash.Location = new System.Drawing.Point(424, 168);
			this.bhash.Multiline = true;
			this.bhash.Name = "bhash";
			this.bhash.ReadOnly = true;
			this.bhash.Size = new System.Drawing.Size(312, 72);
			this.bhash.TabIndex = 7;
			this.bhash.Text = "";
			// 
			// computeHashButton
			// 
			this.computeHashButton.Font = new System.Drawing.Font("Trebuchet MS", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.computeHashButton.Location = new System.Drawing.Point(304, 256);
			this.computeHashButton.Name = "computeHashButton";
			this.computeHashButton.Size = new System.Drawing.Size(144, 40);
			this.computeHashButton.TabIndex = 8;
			this.computeHashButton.Text = "Oblicz skrt";
			this.computeHashButton.Click += new System.EventHandler(this.OnComputeHash);
			// 
			// comparison
			// 
			this.comparison.Font = new System.Drawing.Font("Trebuchet MS", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.comparison.Location = new System.Drawing.Point(328, 72);
			this.comparison.Name = "comparison";
			this.comparison.Size = new System.Drawing.Size(88, 23);
			this.comparison.TabIndex = 9;
			this.comparison.Text = "Rnica";
			this.comparison.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// HashForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 16);
			this.ClientSize = new System.Drawing.Size(760, 310);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.comparison,
																		  this.computeHashButton,
																		  this.bhash,
																		  this.ahash,
																		  this.bdata,
																		  this.adata,
																		  this.label4,
																		  this.label3,
																		  this.label2,
																		  this.label1});
			this.Font = new System.Drawing.Font("Trebuchet MS", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "HashForm";
			this.Text = "Formularz funkcji skrtu";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji..
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new HashForm());
		}

		private static byte[] ConvertStringToByteArray(string s)
		{
			char[] ca = s.ToCharArray();
			byte[] ba = new byte[ca.Length];
			for(int i=0; i<ba.Length; i++)
				ba[i] = (byte)ca[i];
			return ba;
		}
		private void OnComputeHash(object sender, System.EventArgs e)
		{
			// Konwersja A do tablicy bajtw
			Byte[] data1ToHash = ConvertStringToByteArray(adata.Text);	
			// Konwersja B do tablicy bajtw
			Byte[] data2ToHash = ConvertStringToByteArray(bdata.Text);

			// Obliczenie wartoci skrtu dla cigu 1 przy uyciu
			// egzemplarza MD5 zwrconego przez system Crypto Config.
			byte[] hashvaluea = ((HashAlgorithm) CryptoConfig.CreateFromName("MD5")).ComputeHash(data1ToHash);

			ahash.Text = BitConverter.ToString(hashvaluea);

			// Obliczenie wartoci skrtu dla cigu 1 przy uyciu
			// bezporednio utworzonego egzemplarza klasy MD5.
			byte[] hashvalueb = (new MD5CryptoServiceProvider()).ComputeHash(data2ToHash);
			bhash.Text = BitConverter.ToString(hashvalueb);

			// Porwnanie bajtw wartoci skrtw
			bool same = true;
			if(hashvaluea.Length == hashvalueb.Length)
			{
				int i = 0;
				do
				{
					if(hashvaluea[i] != hashvalueb[i])
					{
						same = false;
						break;
					}
					i++;
				}
				while(i < hashvaluea.Length);
			}
			else
				same = false;

			if(same)
				comparison.Text = "Identyczne";
			else
				comparison.Text = "Rne";

		}
	}
}
